﻿//////////////////////////////////////////////
// HdrHeader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Enums/HdrDimension.h"
#include "../Enums/HdrFormat.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

// Standards
#include <vector>
#include <string_view>

/// Internals --------------------------------

namespace nkImages::hdr
{
	struct SizeEntry
	{
		HDR_DIMENSION _firstDimension = HDR_DIMENSION::HDR_DIMENSION_UNKNOWN ;
		unsigned int _firstValue = 0 ;

		HDR_DIMENSION _secondDimension = HDR_DIMENSION::HDR_DIMENSION_UNKNOWN ;
		unsigned int _secondValue = 0 ;
	} ;
}

/// Class ------------------------------------

namespace nkImages::hdr
{
	class HdrHeader final
	{
		public :

			// Functions
			// Getters
			unsigned int getWidth () const ;
			unsigned int getHeight () const ;

			// Encode
			unsigned int getEncodedSize () const ;
			void encodeInData (nkMemory::BufferView<> data) const ;
			// Decode
			void decodeFromData (nkMemory::BufferView<> data) ;

		public :

			// Attributes
			// Informations about data
			HDR_FORMAT _format = HDR_FORMAT::RGB ;
			float _gamma = 1.f ;
			float _exposure = 1.f ;

			// Size info
			SizeEntry _dimensions ;

			// Total byte size after parsing
			unsigned long long _byteSize = 0 ;
	} ;
}